<?php
/*
Plugin Name: Sity Cloud Site Status
Description: تحكم في نشر أو إيقاف نشر موقعك في شبكة ووردبريس (خاصة مالتي سايت) مع صفحة صيانة احترافية باسم Sity Cloud.
Version: 1.1
Author: Sity Cloud
*/

/**
 * إضافة صفحة حالة الموقع في لوحة التحكم
 */
add_action('admin_menu', 'sityc_site_status_menu');
function sityc_site_status_menu() {
    add_menu_page(
        'حالة الموقع - Sity Cloud', // Page title
        'حالة الموقع',              // Menu title
        'manage_options',           // Capability
        'sityc-site-status',        // Menu slug
        'sityc_site_status_page',   // Callback function
        'dashicons-admin-site',     // Icon
        6                           // Position
    );
}

/**
 * صفحة إعدادات حالة الموقع
 */
function sityc_site_status_page() {

    // حفظ الإعدادات
    if (isset($_POST['sityc_site_status_save'])) {
        check_admin_referer('sityc_site_status_save', 'sityc_site_status_nonce');

        $status = isset($_POST['sityc_site_status'])
            ? sanitize_text_field($_POST['sityc_site_status'])
            : 'published';

        if (!in_array($status, ['published', 'unpublished'], true)) {
            $status = 'published';
        }

        update_option('sityc_site_status', $status);

        echo '<div class="notice notice-success is-dismissible"><p>تم تحديث حالة الموقع بنجاح ✅</p></div>';
    }

    $current_status = get_option('sityc_site_status', 'published');
    ?>
    <div class="wrap sityc-status-wrap">
        <h1 class="sityc-title">🌐 حالة الموقع - Sity Cloud</h1>

        <div class="sityc-card">
            <h2>التحكم في ظهور موقعك</h2>
            <p class="sityc-description">
                من هنا تقدر تخلي موقعك <strong>منشور</strong> ويظهر للزوار، أو <strong>غير منشور</strong> ويظهر لهم صفحة صيانة أنيقة باسم Sity Cloud.
            </p>

            <form method="post" action="" id="sityc-site-status-form">
                <?php wp_nonce_field('sityc_site_status_save', 'sityc_site_status_nonce'); ?>

                <div class="sityc-status-container">
                    <label class="sityc-radio">
                        <input type="radio" name="sityc_site_status" value="published" <?php checked($current_status, 'published'); ?>>
                        <span class="sityc-radio-label sityc-on">الموقع منشور (يظهر للزوار)</span>
                    </label>

                    <label class="sityc-radio">
                        <input type="radio" name="sityc_site_status" value="unpublished" <?php checked($current_status, 'unpublished'); ?>>
                        <span class="sityc-radio-label sityc-off">الموقع غير منشور (وضع الصيانة)</span>
                    </label>
                </div>

                <button type="submit" name="sityc_site_status_save" class="button button-primary sityc-btn-primary">
                    💾 حفظ حالة الموقع
                </button>
            </form>
        </div>

        <div class="sityc-card sityc-card-info">
            <h2>ملاحظات</h2>
            <ul class="sityc-list">
                <li>عند تفعيل وضع <strong>غير منشور</strong>، الزوار يشوفوا صفحة صيانة سحابية باسم <strong>Sity Cloud</strong>.</li>
                <li>أنت كأدمن تقدر تفتح الموقع عادي حتى في وضع الصيانة علشان تراجع التعديلات.</li>
            </ul>
        </div>

        <div class="sityc-footer-note">
            Sity Cloud Site Status – تحكم بسيط، تجربة احترافية للزوار.
        </div>
    </div>

    <style>
        .sityc-status-wrap {
            direction: rtl;
            font-family: Tahoma, Arial, sans-serif;
        }
        .sityc-title {
            margin-bottom: 20px;
        }
        .sityc-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 16px;
            padding: 20px 24px;
            margin-bottom: 20px;
            box-shadow: 0 10px 25px rgba(15, 23, 42, 0.08);
            border: 1px solid rgba(148, 87, 235, 0.12);
            position: relative;
            overflow: hidden;
        }
        .sityc-card::before {
            content: '';
            position: absolute;
            inset: -40%;
            background: radial-gradient(circle at top left, rgba(148, 87, 235, 0.12), transparent 55%);
            opacity: 0.6;
            pointer-events: none;
        }
        .sityc-card h2 {
            margin-top: 0;
            margin-bottom: 8px;
        }
        .sityc-description {
            margin-top: 0;
            margin-bottom: 16px;
            color: #555;
        }
        .sityc-status-container {
            display: flex;
            flex-direction: column;
            gap: 12px;
            margin: 16px 0 20px;
        }
        .sityc-radio {
            display: flex;
            align-items: center;
            gap: 8px;
            cursor: pointer;
        }
        .sityc-radio input[type="radio"] {
            transform: scale(1.1);
        }
        .sityc-radio-label {
            padding: 8px 12px;
            border-radius: 999px;
            font-size: 14px;
            border: 1px solid transparent;
        }
        .sityc-radio-label.sityc-on {
            background: rgba(34, 197, 94, 0.08);
            border-color: rgba(34, 197, 94, 0.4);
            color: #15803d;
        }
        .sityc-radio-label.sityc-off {
            background: rgba(239, 68, 68, 0.06);
            border-color: rgba(239, 68, 68, 0.4);
            color: #b91c1c;
        }
        .sityc-btn-primary {
            background: linear-gradient(135deg, #7c3aed, #a855f7);
            border: none;
            box-shadow: 0 8px 20px rgba(124, 58, 237, 0.35);
        }
        .sityc-btn-primary:hover {
            background: linear-gradient(135deg, #6d28d9, #9333ea);
        }
        .sityc-card-info {
            background: rgba(249, 250, 251, 0.9);
        }
        .sityc-list {
            margin: 0;
            padding-right: 18px;
            color: #4b5563;
        }
        .sityc-list li {
            margin-bottom: 6px;
        }
        .sityc-footer-note {
            font-size: 12px;
            color: #6b7280;
            margin-top: 8px;
        }
        @media (max-width: 782px) {
            .sityc-status-container {
                gap: 10px;
            }
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('sityc-site-status-form');
            if (!form) return;

            form.addEventListener('submit', function(e) {
                const selected = form.querySelector('input[name="sityc_site_status"]:checked');
                if (!selected) return;

                if (selected.value === 'unpublished') {
                    const confirmed = confirm('هل أنت متأكد أنك تريد إيقاف نشر الموقع وتفعيل صفحة الصيانة باسم Sity Cloud؟');
                    if (!confirmed) {
                        e.preventDefault();
                    }
                }
            });
        });
    </script>
    <?php
}

/**
 * فحص حالة الموقع قبل عرض الواجهة الأمامية
 */
add_action('template_redirect', 'sityc_check_site_status');
function sityc_check_site_status() {
    $status = get_option('sityc_site_status', 'published');

    // لو الموقع منشور → مفيش حاجة
    if ($status !== 'unpublished') {
        return;
    }

    // السماح للأدمن يشوف الموقع عادي حتى في وضع الصيانة
    if (is_user_logged_in() && current_user_can('manage_options')) {
        return;
    }

    // عرض صفحة صيانة مخصصة بإسم Sity Cloud
    status_header(503);
    header('Retry-After: 3600'); // ساعة

    ?>
    <!DOCTYPE html>
    <html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>الموقع في وضع الصيانة - Sity Cloud</title>
        <style>
            body {
                margin: 0;
                padding: 0;
                font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
                background: radial-gradient(circle at top, #ede9fe, #f9fafb);
                display: flex;
                align-items: center;
                justify-content: center;
                min-height: 100vh;
                direction: rtl;
            }
            .sityc-maint-card {
                background: rgba(255, 255, 255, 0.92);
                backdrop-filter: blur(18px);
                border-radius: 24px;
                padding: 32px 28px;
                max-width: 520px;
                width: 90%;
                text-align: center;
                box-shadow: 0 20px 45px rgba(15, 23, 42, 0.18);
                border: 1px solid rgba(148, 87, 235, 0.18);
                position: relative;
                overflow: hidden;
            }
            .sityc-maint-card::before {
                content: '';
                position: absolute;
                width: 260px;
                height: 260px;
                border-radius: 999px;
                background: radial-gradient(circle, rgba(124, 58, 237, 0.25), transparent 65%);
                top: -90px;
                right: -80px;
                opacity: 0.9;
            }
            .sityc-maint-logo {
                position: relative;
                margin-bottom: 16px;
            }
            .sityc-maint-logo span {
                display: inline-flex;
                align-items: center;
                gap: 6px;
                padding: 6px 12px;
                border-radius: 999px;
                background: rgba(243, 244, 246, 0.95);
                font-size: 13px;
                color: #6b7280;
            }
            .sityc-maint-logo strong {
                color: #7c3aed;
            }
            .sityc-maint-icon {
                position: relative;
                width: 76px;
                height: 76px;
                border-radius: 999px;
                margin: 0 auto 14px;
                display: flex;
                align-items: center;
                justify-content: center;
                background: radial-gradient(circle at top, #7c3aed, #a855f7);
                color: #fff;
                font-size: 36px;
                box-shadow: 0 15px 35px rgba(124, 58, 237, 0.55);
            }
            .sityc-maint-title {
                position: relative;
                font-size: 24px;
                margin-bottom: 10px;
                color: #111827;
            }
            .sityc-maint-text {
                position: relative;
                font-size: 14px;
                color: #4b5563;
                margin-bottom: 16px;
                line-height: 1.7;
            }
            .sityc-maint-note {
                position: relative;
                font-size: 12px;
                color: #6b7280;
                margin-top: 10px;
            }
            .sityc-maint-brand {
                position: relative;
                font-size: 12px;
                color: #7c3aed;
                margin-top: 16px;
            }
        </style>
    </head>
    <body>
        <div class="sityc-maint-card">
            <div class="sityc-maint-logo">
                <span>موقع يعمل على <strong>Sity Cloud</strong></span>
            </div>
            <div class="sityc-maint-icon">🛠️</div>
            <h1 class="sityc-maint-title">الموقع في وضع الصيانة حاليًا</h1>
            <p class="sityc-maint-text">
                نجهّز لك تجربة أفضل على هذا الموقع حاليًا.<br>
                يرجى العودة لاحقًا بعد انتهاء أعمال التحديث والصيانة.
            </p>
            <div class="sityc-maint-note">
                رمز الحالة: 503 – الخدمة غير متاحة مؤقتًا.
            </div>
            <div class="sityc-maint-brand">
                مُدار عبر منصة استضافة المواقع <strong>Sity Cloud</strong>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit;
}
